<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'user';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'nickname', 'slack_id', 'department_id', 'role_id', 'updated_by');

    public function getDepartment()
    {
        return $this->hasOne('App\Models\Departments', 'user_id');
    }

    public function getRole()
    {
        return $this->hasOne('Roles', 'role_id');
    }

}